
typedef struct
{
	long width;  // width of flame buffer.
	long height; // height of flame buffer.
	long fsize;  // number of bytes total in flame buffer.
	long andmask; // and mask indicates how much extra fuel to throw in.
	char *flame1; // frame 1 of flame buffer.
	char *flame2; // frame 2 of flame buffer.
	long *jitter; // 512 byte jitter table used to mix the fuel feeder in.
	long seed;		// current random number seed.
	long fheight; // This is the flame height counter, controls the rate of flame decay
	long fuel; // the controls the strength of the fuel dump.
	long fuelbase; // this is the fuel feeder strength.
	long fire8; // true if doing 8 pixel average for flames.
	long ScreenX; // destination X for flamecopy.
	long ScreenY; // destination Y for flamecopy
	char ctrans[256];  //the color palette translation table if used.
} FLAMESPEC;

//**!! NOTE !! This data structure matches *EXACTLY* the data structure
// in FLAMES.ASM.  If you change this data structure in any way it will
// NOT WORK unless you make the exact corresponding changes to the version
// of the FLAMESPEC structure in FLAMES.ASM


// These are DOS only functions!	They handle support for going directly
// to the Mode 13 320x200 VGA screen.  Under Windows you should use directdraw
// WinG or something else to update your blits.
void cdecl FlameStart(void); // turn 320x200 graphics mode on and set palette (DOS only)
void cdecl FlameCopy(FLAMESPEC *f); // copy flame to VGA mode 13 screen.
void cdecl FlameStop(void); // turn 320x200 graphics mode off (DOS only)
void cdecl FlameZeroScreen(void); //erase screen.
void cdecl FlameImage(char *image); // copy vga screen image.
void cdecl FlameDAC(char *pal); // set vga color palette.
void cdecl FlamePal(char *fpal); // set flame palette, and retrieve settings.

// This routine has self-modified code in it!  Under Windows this will
// cause a protection fault unless you change the read/write access to
// this section of memory!
void cdecl FlameFrame(FLAMESPEC *f);
long cdecl FlameClosestColor(char *pal,long red,long green,long blue);
void cdecl FlameCopyTranslate(FLAMESPEC *f,char *image);
// copy flame and translate it against the translucency table.

